
rem
This class contains represents additional extent info for a particular axis
It has a reference to the geometry whose extents are being tracked. It
also has a min and max extent reference into the ExtentList itself.
The class keeps track of overlaps with other geometries.
end rem
Type TExtentInfo
	Field _geometry:TGeom 'specific to farseer
	Field _min:TExtent
	Field _max:TExtent
	Field _overlaps:TList 'list of geoms
	Field _underConsideration:TList 'list of geoms
	
	Function Create:TExtentInfo(g:TGeom, minv:Float, maxv:Float)
		Local e:TExtentInfo = New TExtentInfo
		e._geometry = g
		e._underConsideration = CreateList()
		e._overlaps = CreateList()
		e._min = TExtent.Create(e, minv, True)
		e._max = TExtent.Create(e, maxv, False)
		Return e
	End Function
End Type
